﻿using System;
using System.Windows.Forms;

namespace Z_29_8
{
    public partial class Main : Form
    {
        public Main()
        {
            InitializeComponent();
        }

        private void btnZatvori_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void btnPonisti_Click(object sender, EventArgs e)
        {
            txtVisina.Text = "";
            txtStarost.Text = "";
            rbZenski.Checked= true;
            lblIdealnaTezina.Text = "...";
        }

        private void btnIzracinaj_Click(object sender, EventArgs e)
        {
            double  visina , starost;
            // 
            if(!double.TryParse(txtVisina.Text ,out visina ))
            {
                MessageBox.Show("Nekorektno uneti podaci za visinu", "Greška");
                return;
            }
            if (!double.TryParse(txtStarost.Text, out starost))
            {
                MessageBox.Show("Nekorektno uneti podaci za starost", "Greška");
                return;
            }
            double koef, idealnaTezina;
            koef = rbZenski.Checked ? 0.85 : 0.9;
            idealnaTezina = (visina - 100 + starost / 10) * koef;
            lblIdealnaTezina.Text = idealnaTezina.ToString("#.##");
        }
    }
}
