﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Kalkulator
{
    public partial class Main : Form
    {
        public Main()
        {
            InitializeComponent();
        }

        private void btnPonisti_Click(object sender, EventArgs e)
        {
            txtx.Text = "";
            txty.Text = "";
            lblrezultat.Text = "...";
        }

        private void btnZatvori_Click(object sender, EventArgs e)
        {
            Close();
        }

        private bool Validate(ref double x, ref double y)
        {
            if (!double.TryParse(txtx.Text, out x))
            {
                MessageBox.Show("Pogrešno uneta vrednost za x", "Greška");
                return false;
            }
            if (!double.TryParse(txty.Text, out y))
            {
                MessageBox.Show("Pogrešno uneta vrednost za y", "Greška");
                return false;
            }
            return true;
        }

        private void btnPlus_Click(object sender, EventArgs e)
        {
            double x = 0, y = 0;
            if (!Validate(ref x, ref y)) return;
            double zbir = x + y;
            lblrezultat.Text = zbir.ToString("0.00");
        }

        private void btnMinus_Click(object sender, EventArgs e)
        {
            double x = 0, y = 0;
            if (!Validate(ref x, ref y)) return;
            double razlika = x - y;
            lblrezultat.Text = razlika.ToString("0.00");
        }

        private void btnPuta_Click(object sender, EventArgs e)
        {
            double x = 0, y = 0;
            if (!Validate(ref x, ref y)) return;
            double proizvod = x * y;
            lblrezultat.Text = proizvod.ToString("0.00");

        }

        private void btnPodeli_Click(object sender, EventArgs e)
        {
            double x = 0, y = 0;
            if (!Validate(ref x, ref y)) return;
            if (y == 0)
            {
                MessageBox.Show("Deljenje nulom nije dozvoljeno", "Greška");
                return;
            }
            double kolicnik = x / y;
            lblrezultat.Text = kolicnik.ToString("0.00");

        }
    }
}
